using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;

namespace WindowsApplication8
{
   public partial class Form1 : Form
   {
      public Form1()
      {
         InitializeComponent();
      }

      private void contactsBindingNavigatorSaveItem_Click(object sender, EventArgs e)
      {
         this.Validate();
         this.contactsBindingSource.EndEdit();
         this.contactsTableAdapter.Update(this.contactsDS.Contacts);

      }

      private void Form1_Load(object sender, EventArgs e)
      {

         // TODO: This line of code loads data into the 'contactsDS.ContactTypes' table. You can move, or remove it, as needed.
         this.contactTypesTableAdapter.Fill(this.contactsDS.ContactTypes);
         // TODO: This line of code loads data into the 'contactsDS.Contacts' table. You can move, or remove it, as needed.
         this.contactsTableAdapter.Fill(this.contactsDS.Contacts);

         contactsDS.ContactTypes.AddContactTypesRow(0, "Kontakt osobisty");
         contactsDS.ContactTypes.AddContactTypesRow(1, "Kontakt biznesowy");

      }

      private void contactsDataGridView_CellFormatting(
         object sender,
         DataGridViewCellFormattingEventArgs e)
      {
         // wr jeli formatowanie dotyczy kolumny, ktr nie jeste zainteresowany
         if (e.RowIndex < 0) return;
         if (e.ColumnIndex != contactsDataGridView.Columns[3].Index) return;
         if ((e.Value == null) ||
            (e.Value == DBNull.Value)) return;
         if (e.RowIndex == contactsDataGridView.NewRowIndex) return;

         int age = (int)e.Value;
         // wiemy, e to kolumna Age, wic bezpiecznie rzutujemy warto
         if (age >= 30)
            e.CellStyle.BackColor = Color.Aquamarine;
      }

      private void contactsDataGridView_CellPainting(
object sender, DataGridViewCellPaintingEventArgs e)
      {
         if (e.RowIndex < 0) return;
         if (e.ColumnIndex != contactsDataGridView.Columns[1].Index) return;
         // jeli element jest wskazany uyj domylnego stylu
         if ((e.State & DataGridViewElementStates.Selected) ==
            DataGridViewElementStates.Selected)
            return;

         Rectangle rect = new Rectangle(e.CellBounds.X, e.CellBounds.Y,
                                         e.CellBounds.Width - 1, e.CellBounds.Height - 1);
         using (LinearGradientBrush lgb =
            new LinearGradientBrush(rect, Color.White, Color.LightCoral, 0f))
         {
            e.Graphics.FillRectangle(lgb, rect);
         }

         // jeli nie ma wartoci do wywietlenia - wracaj
         if ((e.Value == null) || (e.Value == DBNull.Value)) return;
         using (Pen pen = new Pen(contactsDataGridView.GridColor))
         {
            e.Graphics.DrawRectangle(pen, e.CellBounds.X - 1, e.CellBounds.Y - 1,
               e.CellBounds.Width, e.CellBounds.Height);

         }
         // teraz wypisz warto
         StringFormat sf = new StringFormat();
         sf.LineAlignment = StringAlignment.Center;
         sf.Alignment = StringAlignment.Near;

         using (Brush valueBrush = new SolidBrush(e.CellStyle.ForeColor))
         {
            e.Graphics.DrawString(e.Value.ToString(),
                                  e.CellStyle.Font, valueBrush, rect, sf);
         }

         e.Handled = true;
      }

   }
}